@extends('inventory.layout') 
@section('title', 'Orders')
@section('content')
 @push('head')

      <link rel="stylesheet" href="assets/vendors/mdi/css/materialdesignicons.min.css">
    <link rel="stylesheet" href="assets/vendors/css/vendor.bundle.base.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.css" integrity="sha512-5A8nwdMOWrSz20fDsjczgUidUBR8liPYU+WymTZP1lmY9G6Oc7HlZv156XqnsgNUzTyMefFTcsFH/tnJE/+xBg==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700;900&display=swap" rel="stylesheet">

  <style>

    / Style the tab /
.tab {
  overflow: hidden;
  border: 1px solid #ccc;
  background-color: #f1f1f1;
}

/ Style the buttons inside the tab /
.tab button {
  background-color: inherit;
  float: left;
  border: none;
  outline: none;
  cursor: pointer;
  padding: 14px 16px;
  transition: 0.3s;
  font-size: 17px;
}

/ Change background color of buttons on hover /
.tab button:hover {
  background-color: #ddd;
}

/ Create an active/current tablink class /
.tab button.active {
  background-color: #ccc;
}

/ Style the tab content /
.tabcontent {
  display: none;
  padding: 6px 12px;
  border: 1px solid #ccc;
  border-top: none;
}
.tradeadd{
        background-color: #2dce89!important;
        border-color: #2dce89!important;
        color:#fff !important;
        padding: 6px 14px !important;
    }

table {
  font-family: arial, sans-serif;
  border-collapse: collapse;
  width: 100%;
}

td, th {
  border: 1px solid #dddddd;
  text-align: left;
  padding: 8px;
}

/*tr:nth-child(even) {
  background-color: #dddddd;
}*/
#content1::after{
    content: "\a";
    white-space: pre;
    }
    #title:after{
        content: "\a";
        white-space: pre;
    }
    #desc{
        color: #D3D3D3 !important;
    }
    #wisestep_count select, #wisestep_count input{
      border: 1px solid #8c8c8c;
    height: 45px !important;
    border-radius: 5px;
    color: #8c8c8c;
    }
    #wisestep_count .submitbtn, #wisestep_count .submitstage{
      height: 45px;
    padding: 0 20px;
    background: #333;
    border: 1px solid #333;
    color: #fff;
    border-radius: 5px;
    font-weight: 600;
    }

     #wisestep_count tr td:first-child{
      width:30%;
     }
     #bottomstage tr td{
      width: 30%;
     }
     .wisestep_sr{
      font-size: 17px !important;
      padding-left: 15px;
      background:#f0f0f0;
     }
     /*.totlsteps{

    margin-bottom: 0px;
    text-align: left;
    padding-top: 15px;*/
    .totlsteps {
    margin-bottom: 0px;
    text-align: left;
  
    /*color: #4249A3;*/
}

     #wisestep_count{
     padding: 20px;
    margin-bottom: 30px;
    border-bottom-left-radius: 10px;
    border-bottom-right-radius: 10px;
    border: 1px solid #a4a4a4;

    overflow: hidden;
    z-index: 1;
    position: relative;

  }
  .wisetable_steps{
    margin-top: 20px;
  }
  #bottomstage:before{
    content: "";
    position: absolute;
    width: 100%;
    height: 1px;
    background: #a4a4a4;
    left: 0;
    margin-top: -20px;
  }
  #bottomstage{
    margin-top: 40px;
  }
    
    .error{
      color: red;
    }
    /*.searchclass{
        text-transform:capitalize;
    }*/
    .tradeadd{
        background-color: #2dce89;
        border-color: #2dce89;
        color:#fff !important;
    }
    .tradeadd:hover{
    background-color:#2dce89;
    border-color: #2dce89;
    }
    .showmedia{
        padding-right: 10px;
    }


  </style>
    <!-- Layout styles -->
    <link rel="stylesheet" href="{{ url('assets/css/style.css')}}">
    <link rel="stylesheet" href="{{ url('assets/css/custom.css')}}">
    <!-- End layout styles -->
    <link rel="shortcut icon" href="{{ url('assets/images/favicon.ico')}}" />
  @endpush
    <!-- push external head elements to head --> 
    <div class="container-fluid">
        <div class="page-header">
            <div class="row align-items-end">
                <div class="col-lg-8">
                    <div class="page-header-title">
                        <!-- <i class="ik ik-users bg-green"></i> -->
                        <div class="d-inline">
                            <h5>{{ isset($orders[0]->clientdetail->name) ? $orders[0]->clientdetail->name :'' }} Orders</h5>
                            <span>View orders</span>
                        </div>
                    </div>
                </div>
                {{--<div class="col-lg-4">
                    <nav class="breadcrumb-container" aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item">
                                <a href="{{url('dashboard')}}"><i class="ik ik-home"></i></a>
                            </li>
                            <li class="breadcrumb-item">
                                <a href="#">Orders</a>
                            </li>
                        </ol>
                    </nav>
                </div>--}}
            </div>
        </div>
        <div class="row">
            <!-- list layout 1 start -->
            <div class="col-md-12">
                <div class="card">
                    <div class="card-header row">
                       
                        <div class="col col-sm-6">
                            {{--<div class="card-search with-adv-search dropdown">
                                <form action="" method="get">
                                    <input type="text" class="form-control global_filter searchclass" id="search" name="search" placeholder="Search.." >
                                    <button type="submit" class="btn btn-icon"><i class="ik ik-search"></i></button>
                                    <button type="button" id="adv_wrap_toggler_1" class="adv-btn ik ik-chevron-down dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"></button>
                                    
                                </form>
                            </div>--}}
                        </div>
                        <div class="col col-sm-5">
                            <div class="card-options text-right">
                                <span class="mr-5" id="top">{{--{{($orders->currentpage()-1)*$orders->perpage()+1}} to {{$orders->currentpage()*$orders->perpage()}}
                                            of  {{$orders->total()}}--}} entries</span>
                              
                                <a href="{{route('createorder',$clientid)}}" class=" btn btn-outline-primary btn-semi-rounded tradeadd"><i class="ik ik-plus"></i>&nbsp;Add Order</a>
                            </div>
                           
                        </div>
                    </div>
                    <div class="card-body">
                        <table id="product_table" class="table parenttable">
                            <thead>
                                <tr>
                                    
                                    <th>{{ __('Order No')}}</th>
                                    <th>{{ __('Client Name')}}</th>
                                    <th>{{ __('Contact Person')}}</th>
                                    <th>{{ __('Address')}}</th>
                                     <th>{{ __('Created')}}</th>
                                     <th>{{ __('Status')}}</th>
                                    <th style="width: 100px;!important">{{ __('Action')}}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($orders as $order)
                                <tr>
                                     <td>{{ isset($order->id) ? $order->id :'' }}</td>

                                        <td>{{ isset($order->clientdetail->name) ? $order->clientdetail->name :'' }}</td>

                                        <td>{{ isset($order->contactPerson) ? $order->contactPerson :'' }}</td> 
                                        
                                        <td>{{ isset($order->Address) ? $order->Address :'' }}</td>
                                        <td>{{ isset($order->created_at) ? \Carbon\Carbon::parse($order->created_at)->format('d M Y') :'' }}</td>
                                        <td data-label="Status" class="has-text-grey is-abbr-like totalstages" style="font-size: 13px; border: 1px solid rgb(219, 219, 219);">
                                        <table width="100%" style="line-height: 10px;">
                                        @foreach($stageorder as $sorder)

                                        <tr>
                                            <td width="60%" style="border-bottom: 1px dotted rgb(219, 219, 219); padding: 10px 0px;"><strong>Total Stages:</strong></td> 
                                            <td width="40%" style="border-bottom: 1px dotted rgb(219, 219, 219); padding: 10px 0px;">{{isset($sorder->totalstage) ? $sorder->totalstage:''}}
        
                                        </td>
                                        </tr>
                                        @endforeach
                                        @foreach($stageorder as $sorder)
                                        @if(isset($inprcess) && $inprcess !='[]')
                                        @foreach($inprcess as $process)
                                        @foreach($completed as $complt) 
                                        <tr>
                                            <td width="60%" style="border-bottom: 1px dotted rgb(219, 219, 219); padding: 10px 0px;"><strong>Not Started:</strong>
                                            </td> 
                                            <td width="40%" style="border-bottom: 1px dotted rgb(219, 219, 219); padding: 10px 0px;">{{$sorder->totalstage-($process->inprocess)-($complt->completed)}}</td>
                                        </tr> 
                                        @endforeach
                                        @endforeach
                                        @elseif(isset($completed) && $completed!='[]')
                                        @foreach($completed as $complt)
                                        <tr>
                                            <td width="60%" style="border-bottom: 1px dotted rgb(219, 219, 219); padding: 10px 0px;"><strong>Not Started:</strong>
                                            </td> 
                                            <td width="40%" style="border-bottom: 1px dotted rgb(219, 219, 219); padding: 10px 0px;">{{$sorder->totalstage-$complt->completed}}</td>
                                        </tr> 
                                        @endforeach

                                        @else
                                                                                <tr>
                                            <td width="60%" style="border-bottom: 1px dotted rgb(219, 219, 219); padding: 10px 0px;"><strong>Not Started:</strong>
                                            </td> 
                                            <td width="40%" style="border-bottom: 1px dotted rgb(219, 219, 219); padding: 10px 0px;">{{$sorder->totalstage}}</td>
                                        </tr> 
                                        @endif
                                        @endforeach
                                        
                                        @if(isset($inprcess) && $inprcess !='[]')
                                        @foreach($inprcess as $process) 

                                        <tr>
                                            <td width="60%" style="border-bottom: 1px dotted rgb(219, 219, 219); padding: 10px 0px;"><strong>In Process:</strong></td> <td width="40%" style="border-bottom: 1px dotted rgb(219, 219, 219); padding: 10px 0px;">{{isset($process->inprocess) ? $process->inprocess:''}}</td>
                                        </tr>
                                        
                                        @endforeach
                                        @else
                                        <tr>
                                            <td width="60%" style="border-bottom: 1px dotted rgb(219, 219, 219); padding: 10px 0px;"><strong>In Process:</strong></td> <td width="40%" style="border-bottom: 1px dotted rgb(219, 219, 219); padding: 10px 0px;">0</td>
                                        </tr>
                                        @endif
                                        
                                        @if(isset($completed) && $completed !='[]')
                                        @foreach($completed as $complt) 

                                        <tr>
                                            <td width="60%" style="padding: 10px 0px;"><strong>Completed:</strong></td> <td width="40%" style="padding: 10px 0px;">{{isset($complt->completed) ? $complt->completed:''}}</td>
                                        </tr>
                                        @endforeach
                                        @else
                                        <tr>
                                            <td width="60%" style="padding: 10px 0px;"><strong>Completed:</strong></td> <td width="40%" style="padding: 10px 0px;">0</td>
                                        </tr>
                                        @endif
                                        
                                        {{--<tr>
                                            
                                            <td width="60%" style="padding: 10px 0px;"><strong>User Group:</strong></td> 
                                            @foreach($stggrp as $key=>$grp)
                                            @if($key==0)
                                                <td width="100%" style="padding: 10px 0px;">
                                                
                                                {{isset($grp->groupname) ? $grp->groupname:''}}
                                            @else
                                                    {{','.$grp->groupname}}</td>
                                            @endif
                                            
                                            @endforeach
                                        </tr>--}}

                                        @foreach($stggrp as $key=>$grp)

                                        @foreach($groupscount as $gcount)
                                       
                                        @if($grp->group_id == $gcount->group_id)
                                        
                                        <tr>
                                            
                                            <td width="60%" style="padding: 10px 0px;"><a href="{{url('groupdetail'.'/'.$grp->group_id.'/'.$order->id)}}"><strong>{{isset($grp->groupname) ? $grp->groupname:''}}</strong></a></td> 
                                           
                                                <td width="100%" style="padding: 10px 0px;">
                                                @foreach($chgroups as $groups)
                                                @if($groups->group_id==$gcount->group_id)
                                                {{$groups->completed}} Completed Out of  
                                                @endif
                                                @endforeach {{$gcount->count }} Stages</td>
                                               
                                        </tr>
                                    
                                        @endif
                                       
                                        @endforeach
                                        @endforeach
                                        </table>
                                        </td>
                                    <td> 
                                        <a href="{{route('order.show', $order->id) }}"  ><i class="fa fa-paper-plane text-green"></i></a>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                        
                                        <a href="{{route('order.edit', $order->id) }}"  ><i class="ik ik-edit-2  text-green"></i></a>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;

                                        <a href="javascript:;" class="deleteorderid" data-id="{{ isset($order->id) ? $order->id:'' }}"  data-url="{{route('orderdelete',$order['id'])}}"><i class="ik ik-trash-2 f-16 text-red"></i></a>
                                        
                                    </td>
                                </tr>
                                @endforeach

                            </tbody>
                        </table>

                        <div class="card-footer d-flex align-items-center">

                                <div class="col-md-6">
                                </div>
                                
                                <div class="col-md-6">
                                {{--{{ $orders->links('include.pagination') }}--}}
                                </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- list layout 1 end -->
            <div class="col-md-12"><hr></div>
            <!-- list layout 2 -->
            
            <!-- list layout 2 end -->
        </div>
    </div>
    
    <!-- category add modal-->

@push('script')

<script src="{{ url('assets/vendors/js/vendor.bundle.base.js')}}"></script>
    <!-- endinject -->
    <!-- Plugin js for this page -->
    <script src="{{ url('assets/vendors/chart.js/Chart.min.js')}}"></script>
    <script src="{{ url('assets/js/jquery.cookie.js')}}" type="text/javascript"></script>
    <!-- End plugin js for this page -->
    <!-- inject:js -->
    <script src="{{ url('assets/js/off-canvas.js')}}"></script>
    <script src="{{ url('assets/js/hoverable-collapse.js')}}"></script>
    <script src="{{ url('assets/js/misc.js')}}"></script>
    <!-- endinject -->
    <!-- Custom js for this page -->
    <script src="{{ url('assets/js/dashboard.js')}}"></script>
    <script src="{{ url('assets/js/todolist.js')}}"></script>

<script src="{{ url('js/global.js')}}"></script>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-3-typeahead/4.0.1/bootstrap3-typeahead.min.js"></script>
<script src = "http://cdn.datatables.net/1.10.18/js/jquery.dataTables.min.js"></script>

<script type="text/javascript">

    var route = "{{ url('listsearch') }}";
 $('#search').typeahead({
            source: function (query, process) {
                return $.get(route, {
                    query: query
                }, function (data) {
                    console.log(data);
                    return process(data);
                });
            }
        });

 /*$(document).ready(function () {
    $('#product_table').DataTable({
        order: [[3, 'desc']],
    });
});*/
var table = $('#product_table').DataTable({

        paging: false,
        ordering: true,
        info: false,
        searching:false,
    });

</script>
 @endpush
 @endsection